#ifndef _SMV_TYPES_H
#define _SMV_TYPES_H


#define SMV_FAST_RENDER		1


/* I like to use boolean types in C */
#define TRUE	1
#define FALSE	0

/* If compiling on a non-Linux/x86 platform, please check these */
typedef unsigned short 	tWORD;  	/* 16 bits */
typedef signed long 		tLONG;	/* 32 bits */

typedef unsigned int 	BOOL;

/* Low-level 3DS data */
typedef struct {
				float x,y,z;
				} MVERTEX;

typedef struct {
				tWORD v1,v2,v3;
				} MFACE;

/* High-level object data */

typedef struct sMVMODEL {
				tWORD			iNumVertices;
				MVERTEX		*pVertexList;
				tWORD			iNumFaces;
				MFACE			*pFaceList;
				/* Basic linked list here */
				struct sMVMODEL	*pNext;	
				} MV_MODEL;

typedef struct {
				char		szName[256];

 				MVERTEX	pos;
				float		xangle, yangle, zangle;

				MV_MODEL	*pMesh;
				} MV_OBJECT;

#endif
