#include <stdlib.h>
#include <GL/glut.h>
#include "smv_Types.h"
#include "smv_Object.h"

MV_OBJECT *Obj_CreateObject(void)
{
MV_OBJECT *pObj;

	pObj = (MV_OBJECT *)malloc(sizeof(MV_OBJECT));
	if (pObj == 0)
		return 0;

	pObj->pos.x = pObj->pos.y = pObj->pos.z = 0;
	pObj->xangle = pObj->yangle = pObj->zangle = 0;
	pObj->pMesh = 0;
	return pObj;
}

void Obj_DrawObject(MV_OBJECT *pObj)
{
tWORD i;
MVERTEX *pVList;
MFACE *pFList;
MV_MODEL *pCurrMesh;

	/* Position the object in the world */
	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
	glLoadIdentity();
	glTranslatef(pObj->pos.x, pObj->pos.y, pObj->pos.z);
	glRotatef(pObj->xangle, 1.0, 0.0, 0.0);
	glRotatef(pObj->yangle, 0.0, 1.0, 0.0);
	glRotatef(pObj->zangle, 0.0, 0.0, 1.0);

	/* We should read the ambient colour for this instead */
	glColor3f(0.0f,0.0f,0.0f);

	/* Make these synonyms to ease comprehension */
	pCurrMesh = pObj->pMesh;
	while(pCurrMesh)
		{	
		pFList = pCurrMesh->pFaceList;
		pVList = pCurrMesh->pVertexList;

#if SMV_FAST_RENDER

		glEnableClientState(GL_VERTEX_ARRAY);
		glVertexPointer(3, GL_FLOAT, 0, (void *)pCurrMesh->pVertexList);

		for(i=0;i<pCurrMesh->iNumFaces;i++)
			{
			glBegin(GL_LINE_LOOP);
				glArrayElement( pFList[i].v1);
				glArrayElement( pFList[i].v2);
				glArrayElement( pFList[i].v3);
			glEnd();
			}
#else
		for(i=0;i<pCurrMesh->iNumFaces;i++)
			{
			glBegin(GL_LINE_LOOP);
				glVertex3d(pVList[pFList[i].v1].x, pVList[pFList[i].v1].y, pVList[pFList[i].v1].z);
				glVertex3d(pVList[pFList[i].v2].x, pVList[pFList[i].v2].y, pVList[pFList[i].v2].z);
				glVertex3d(pVList[pFList[i].v3].x, pVList[pFList[i].v3].y, pVList[pFList[i].v3].z);
			glEnd();
			}
#endif
		pCurrMesh = pCurrMesh->pNext;
		}
	glPopMatrix();
	glFlush();
}

void Obj_SetPosition(MV_OBJECT *pObj, float x, float y, float z)
{
	pObj->pos.x = x;
	pObj->pos.y = y;
	pObj->pos.z = z;
}

void Obj_GetPosition(MV_OBJECT *pObj, float *x, float *y, float *z)
{
	if (x) *x = pObj->pos.x;
	if (y) *y = pObj->pos.y;
	if (z) *z = pObj->pos.z;
}


void Obj_SetOrientation(MV_OBJECT *pObj, float rx, float ry, float rz)
{
	pObj->xangle = rx;
	pObj->yangle = ry;
	pObj->zangle = rz;
}

void Obj_GetOrientation(MV_OBJECT *pObj, float *rx, float *ry, float *rz)
{
	if (rx) *rx = pObj->xangle;
	if (ry) *ry = pObj->yangle;
	if (rz) *rz = pObj->zangle;
}

