#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "smv_Types.h"
#include "smv_Disc.h"

/*
** Disc Handling Code
*/
BOOL mv_ReadWord(FILE *file_ptr, tWORD *pWord)
{
int c;

	if ((c = fgetc(file_ptr)) == -1)		return FALSE;
	*pWord = (tWORD)c;
	if ((c = fgetc(file_ptr)) == -1)		return FALSE;
	*pWord |= (tWORD)c<<8;
	return TRUE;
}

BOOL mv_ReadLong(FILE *file_ptr, tLONG *pLong)
{
int c;

	if ((c = fgetc(file_ptr)) == -1)	return FALSE; else *pLong  = (tLONG)c;
	if ((c = fgetc(file_ptr)) == -1)	return FALSE; else *pLong |= (tLONG)c<<8;
	if ((c = fgetc(file_ptr)) == -1)	return FALSE; else *pLong |= (tLONG)c<<16;
	if ((c = fgetc(file_ptr)) == -1)	return FALSE; else *pLong |= (tLONG)c<<24;

	return TRUE;
}

BOOL mv_ReadFloat(FILE *file_ptr, float *pFloat)
{
tLONG val;

	if (mv_ReadLong(file_ptr, &val) == FALSE)		return FALSE;
	*pFloat = *(float *)&val;
	return TRUE;
}

BOOL mv_SkipBytes(FILE *file_ptr, tLONG size)
{
	return fseek(file_ptr, size, SEEK_CUR)==0?TRUE:FALSE;
}

BOOL mv_SkipChunk(FILE *file_ptr, tLONG size)
{
	/* 3DS files include the header as part of the chunk */
	size -= sizeof(tWORD);
	size -= sizeof(tLONG);
	return mv_SkipBytes(file_ptr, size);
}

BOOL mv_ReadString(FILE *file_ptr, char *pString, int iMaxSize)
{
int count=0,c;
char *pStr = pString;

	*pString = '\0';		/* make it empty, just in case there's nothing here! */
	do
		{
		c = fgetc(file_ptr);
		if (c == -1)	/* EOF */
			return FALSE;

		if (count < iMaxSize)
			{
			*pStr++ = c;
			count++;
			}
		}
	while(c);

	*pStr = '\0';	/* add a NUL terminator */

	return TRUE;	
}


BOOL mv_ReadChunk(FILE *file_ptr, tWORD *pID, tLONG *pSize)
{
	if (mv_ReadWord(file_ptr, pID) == FALSE)		return FALSE;
	if (mv_ReadLong(file_ptr, pSize) == FALSE)	return FALSE;
	return TRUE;
}

