#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <GL/glut.h>

#include "smv_Types.h"
#include "smv_Disc.h"
#include "smv_Parse.h"
#include "smv_Object.h"

/*
** Simple Model Viewer - aka Steev's Model Viewer
** Released under the GPL
** Version 1.0
** written for Linux Magazine. January 2002
*/

MV_OBJECT *g_pMainObject;
int mousemotion, mousex, mousey;
GLfloat xangle = 4;   /* for rotation */
GLfloat yangle = 120;


void mouse(int button, int state, int x, int y)
 {
  if (button == GLUT_LEFT_BUTTON && state == GLUT_DOWN) {
    mousemotion = 1;
    mousex = x;
    mousey = y;
  }
  if (button == GLUT_LEFT_BUTTON && state == GLUT_UP) {
    mousemotion = 0;
  }
 }

 //Callback Function: Reaction of mouse movement
 void motion(int x, int y)
 {
  if (mousemotion) {
    xangle = xangle - (y - mousey);
    yangle = yangle - (x - mousex);
    mousex = x;
    mousey = y;

	Obj_SetOrientation(g_pMainObject, xangle, yangle, 0);

    // Draw a new display
    glutPostRedisplay();
  }
 }

void DrawScene(void)
{
	glClearColor (0.8, 0.8, 0.8, 0.0);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(60, 1/1, 0,1000);
	gluLookAt(
		0,0,250,		/* from position */
		50,0,0,		/* to position */
		0.0, 0.0, 1.0);

	Obj_DrawObject(g_pMainObject);

	glutSwapBuffers();
}

void keyb( unsigned char keyPressed, int sx, int sy )
{
float dist = 10.0f;
float x, y, z;

        switch( keyPressed ) {
                case 'q':
			exit(0);
			break;
                case 'z':
			Obj_GetPosition(g_pMainObject, &x, &y, &z);
			Obj_SetPosition(g_pMainObject, x-dist, y, z);
			break;
                case 'x':
			Obj_GetPosition(g_pMainObject, &x, &y, &z);
			Obj_SetPosition(g_pMainObject, x+dist, y, z);
			break;
                case 'k':
			Obj_GetPosition(g_pMainObject, &x, &y, &z);
			Obj_SetPosition(g_pMainObject, x, y-dist, z);
			break;
                case 'm':
			Obj_GetPosition(g_pMainObject, &x, &y, &z);
			Obj_SetPosition(g_pMainObject, x, y+dist, z);
			break;
                case 'j':
			Obj_GetPosition(g_pMainObject, &x, &y, &z);
			Obj_SetPosition(g_pMainObject, x, y, z-dist);
			break;
                case 'n':
			Obj_GetPosition(g_pMainObject, &x, &y, &z);
			Obj_SetPosition(g_pMainObject, x, y, z+dist);
			break;
        }
    glutPostRedisplay();
 }

int main(int argc, char *argv[])
{
	if (argc > 1)
		g_pMainObject = mv_ParseFile(argv[1]);
	else
		g_pMainObject = mv_ParseFile("rocket.3ds");

	if (!g_pMainObject)
		{
		fprintf(stderr, "Can not load mesh file...\n");
		return EXIT_FAILURE;
		}

	Obj_SetOrientation(g_pMainObject, xangle, yangle, 0);

  glutInit(&argc, argv);
  glutInitDisplayMode (GLUT_DOUBLE | GLUT_DEPTH);
  glutInitWindowSize (500, 500);
  glutInitWindowPosition (100, 100);
  glutCreateWindow (argv[0]);

  glDepthFunc(GL_LEQUAL);
  glEnable(GL_DEPTH_TEST);

  //Callbacks set: Reaction to Mouse clicks and - movements, keyboard activities
  glutMouseFunc(mouse);
  glutMotionFunc(motion);
  glutKeyboardFunc(keyb);

         //Callback for drawing the GL function
  glutDisplayFunc(DrawScene);

  glutMainLoop();

  return EXIT_SUCCESS;

}
