#include "phHTML.h"

IMPLEMENT_ELEMENT(CHTMLElement_TT,		"TT",	NODE_ID_TT,		NODE_FLG_ELEMENT);
IMPLEMENT_ELEMENT(CHTMLElement_I,		"I",	NODE_ID_ITALIC,	NODE_FLG_ELEMENT);
IMPLEMENT_ELEMENT(CHTMLElement_B,		"B",	NODE_ID_BOLD,	NODE_FLG_ELEMENT);
IMPLEMENT_ELEMENT(CHTMLElement_U,		"U",	NODE_ID_UNDERLINE,	NODE_FLG_ELEMENT | NODE_FLG_DEPRECATED);
IMPLEMENT_ELEMENT(CHTMLElement_S,		"S",	NODE_ID_STRIKE,	NODE_FLG_ELEMENT | NODE_FLG_DEPRECATED);
IMPLEMENT_ELEMENT(CHTMLElement_Strike,	"Strike",NODE_ID_STRIKE,NODE_FLG_ELEMENT | NODE_FLG_DEPRECATED);
IMPLEMENT_ELEMENT(CHTMLElement_Big,		"Big",	NODE_ID_BIG,	NODE_FLG_ELEMENT);
IMPLEMENT_ELEMENT(CHTMLElement_Small,	"Small",NODE_ID_SMALL,	NODE_FLG_ELEMENT);

IMPLEMENT_ELEMENT(CHTMLElement_EM,		"EM",	NODE_ID_EM,	NODE_FLG_ELEMENT);
IMPLEMENT_ELEMENT(CHTMLElement_Strong,	"STRONG",NODE_ID_STRONG,NODE_FLG_ELEMENT);
IMPLEMENT_ELEMENT(CHTMLElement_Dfn,		"DFN",	NODE_ID_DFN,	NODE_FLG_ELEMENT);
IMPLEMENT_ELEMENT(CHTMLElement_Code,	"CODE",	NODE_ID_CODE,	NODE_FLG_ELEMENT);
IMPLEMENT_ELEMENT(CHTMLElement_Samp,	"SAMP",	NODE_ID_SAMP,	NODE_FLG_ELEMENT);
IMPLEMENT_ELEMENT(CHTMLElement_Kbd,		"KBD",	NODE_ID_KBD,	NODE_FLG_ELEMENT);
IMPLEMENT_ELEMENT(CHTMLElement_Var,		"VAR",	NODE_ID_VAR,	NODE_FLG_ELEMENT);
IMPLEMENT_ELEMENT(CHTMLElement_Cite,	"CITE",	NODE_ID_CITE,	NODE_FLG_ELEMENT);
IMPLEMENT_ELEMENT(CHTMLElement_Abbr,	"ABBR",	NODE_ID_ABBR,	NODE_FLG_ELEMENT);

IMPLEMENT_ELEMENT(CHTMLElement_Sub,		"SUB",	NODE_ID_SUB,	NODE_FLG_ELEMENT);
IMPLEMENT_ELEMENT(CHTMLElement_Sup,		"SUP",	NODE_ID_SUP,	NODE_FLG_ELEMENT);
IMPLEMENT_ELEMENT(CHTMLElement_Span,	"SPAN",	NODE_ID_SPAN,	NODE_FLG_ELEMENT);
IMPLEMENT_ELEMENT(CHTMLElement_BDO,		"BDO",	NODE_ID_BDO,	NODE_FLG_ELEMENT);

IMPLEMENT_ELEMENT(CHTMLElement_BaseFont,"BASEFONT",	NODE_ID_BASEFONT,	NODE_FLG_ELEMENT | NODE_FLG_ENDTAG_FORBIDDEN | NODE_FLG_DEPRECATED);
IMPLEMENT_ELEMENT(CHTMLElement_Font,	"FONT",	NODE_ID_FONT,	NODE_FLG_ELEMENT | NODE_FLG_DEPRECATED);
IMPLEMENT_ELEMENT(CHTMLElement_BR,		"BR",	NODE_ID_BR,	NODE_FLG_ELEMENT | NODE_FLG_ENDTAG_FORBIDDEN);


/*
** fontstyle
*/
ATTRINFO_BEGIN(CHTMLElement_TT);
	ATTRINFO_ENTITY("", m_Attrs);
ATTRINFO_END();

ATTRINFO_BEGIN(CHTMLElement_I);
	ATTRINFO_ENTITY("", m_Attrs);
ATTRINFO_END();

ATTRINFO_BEGIN(CHTMLElement_B);
	ATTRINFO_ENTITY("", m_Attrs);
ATTRINFO_END();

ATTRINFO_BEGIN(CHTMLElement_U);
	ATTRINFO_ENTITY("", m_Attrs);
ATTRINFO_END();

ATTRINFO_BEGIN(CHTMLElement_S);
	ATTRINFO_ENTITY("", m_Attrs);
ATTRINFO_END();

ATTRINFO_BEGIN(CHTMLElement_Strike);
	ATTRINFO_ENTITY("", m_Attrs);
ATTRINFO_END();

ATTRINFO_BEGIN(CHTMLElement_Big);
	ATTRINFO_ENTITY("", m_Attrs);
ATTRINFO_END();

ATTRINFO_BEGIN(CHTMLElement_Small);
	ATTRINFO_ENTITY("", m_Attrs);
ATTRINFO_END();

/*
** phrase
*/
ATTRINFO_BEGIN(CHTMLElement_EM);
	ATTRINFO_ENTITY("", m_Attrs);
ATTRINFO_END();

ATTRINFO_BEGIN(CHTMLElement_Strong);
	ATTRINFO_ENTITY("", m_Attrs);
ATTRINFO_END();

ATTRINFO_BEGIN(CHTMLElement_Dfn);
	ATTRINFO_ENTITY("", m_Attrs);
ATTRINFO_END();

ATTRINFO_BEGIN(CHTMLElement_Code);
	ATTRINFO_ENTITY("", m_Attrs);
ATTRINFO_END();

ATTRINFO_BEGIN(CHTMLElement_Samp);
	ATTRINFO_ENTITY("", m_Attrs);
ATTRINFO_END();

ATTRINFO_BEGIN(CHTMLElement_Kbd);
	ATTRINFO_ENTITY("", m_Attrs);
ATTRINFO_END();

ATTRINFO_BEGIN(CHTMLElement_Var);
	ATTRINFO_ENTITY("", m_Attrs);
ATTRINFO_END();

ATTRINFO_BEGIN(CHTMLElement_Cite);
	ATTRINFO_ENTITY("", m_Attrs);
ATTRINFO_END();

ATTRINFO_BEGIN(CHTMLElement_Abbr);
	ATTRINFO_ENTITY("", m_Attrs);
ATTRINFO_END();

/*
**
*/
ATTRINFO_BEGIN(CHTMLElement_Sub);
	ATTRINFO_ENTITY("", m_Attrs);
ATTRINFO_END();

ATTRINFO_BEGIN(CHTMLElement_Sup);
	ATTRINFO_ENTITY("", m_Attrs);
ATTRINFO_END();

ATTRINFO_BEGIN(CHTMLElement_Span);
	ATTRINFO_ATTR("charset",m_Charset);
	ATTRINFO_ATTR("type",	m_Type);
	ATTRINFO_ATTR("href",	m_href);
	ATTRINFO_ATTR("hreflang",m_hreflang);
	ATTRINFO_ATTR("target", m_Target);
	ATTRINFO_ATTR("rel",	m_Rel);
	ATTRINFO_ATTR("rev",	m_Rev);
	ATTRINFO_ATTR("media",	m_Media);
	ATTRINFO_ENTITY("", m_Attrs);
ATTRINFO_END();

ATTRINFO_BEGIN(CHTMLElement_BDO);
	ATTRINFO_ATTR("lang", m_LangCode);
	ATTRINFO_ATTR("dir", m_Dir);
	ATTRINFO_ENTITY("", m_CoreAttrs);
ATTRINFO_END();

bool CHTMLElement_BDO::ValidateRequiredAttrs(CBDParser *pParser)
{ 
	if (!m_Dir.IsSpecified())
		{
		pParser->AddError(HERR_NO_REQD_ATTR, "The <%s> tag requires the 'dir' attribute", GetName(), NULL, GetLine(), GetCol());
		return false;
		}
	return true;
}

/*
**
*/
ATTRINFO_BEGIN(CHTMLElement_BaseFont);
	ATTRINFO_ATTR("id", m_ID);
	ATTRINFO_ATTR("size", m_Size);
	ATTRINFO_ATTR("face", m_Face);
	ATTRINFO_ATTR("color", m_Color);
ATTRINFO_END();

bool CHTMLElement_BaseFont::ValidateRequiredAttrs(CBDParser *pParser)
{ 
	if (!m_Size.IsSpecified())
		{
		pParser->AddError(HERR_NO_REQD_ATTR, "The <%s> tag requires the 'size' attribute", GetName(), NULL, GetLine(), GetCol());
		return false;
		}
	return true;
}

ATTRINFO_BEGIN(CHTMLElement_Font);
	ATTRINFO_ATTR("size", m_Size);
	ATTRINFO_ATTR("face", m_Face);
	ATTRINFO_ATTR("color", m_Color);
	ATTRINFO_ENTITY("", m_CoreAttrs);
	ATTRINFO_ENTITY("", m_i18n);
ATTRINFO_END();

ATTRINFO_BEGIN(CHTMLElement_BR);
	ATTRINFO_ATTR("clear", m_Clear);
	ATTRINFO_ENTITY("", m_CoreAttrs);
ATTRINFO_END();
