/*
 * midiutil.h - Header for auxiliary MIDI functionality. 
 * Version 1.0
 *
 *  AUTHOR: Steven Goodwin (steev@BlueDust.com)
 *			Copyright 2001, Steven Goodwin.
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License,or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "midiinfo.h"


#ifndef _MIDIUTIL_H
#define _MIDIUTIL_H

/*
** Name resolving prototypes
*/
BOOL	muGetInstrumentName(char *pName, int iInstr);
BOOL	muGetDrumName(char *pName, int iInstr);
BOOL	muGetMIDIMsgName(char *pName, tMIDI_MSG iMsg);
BOOL	muGetControlName(char *pName, tMIDI_CC iCC);
BOOL	muGetKeySigName(char *pName, tMIDI_KEYSIG iKey);
BOOL	muGetTextName(char *pName, tMIDI_TEXT iEvent);
BOOL	muGetMetaName(char *pName, tMIDI_META iEvent);

/*
** Conversion prototypes
*/
int		muGetNoteFromName(const char *pName);
char	*muGetNameFromNote(char *pStr, int iNote);
float	muGetFreqFromNote(int iNote);
int		muGetNoteFromFreq(float fFreq);

#endif	/* _MIDIUTIL_H*/
