#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "converter.h"
#include "process.h"

CONVERTER *g_pConvertTable;

static CONVERTER *GetConversion(const char *pFromUnit)
{
CONVERTER *pConv = g_pConvertTable;

	while(pConv)
		{
		if (strcmp(pConv->szFromUnits, pFromUnit) == 0)
			return pConv;
		pConv = pConv->pNext;
		}
	return 0;
}

int AddConversion(CONVERTER *pConv)
{
CONVERTER *pC = malloc(sizeof(CONVERTER));

	if (!pC)	return 0;

	*pC = *pConv;		/* a bitwise structure copy is allowed */
	pC->pNext = g_pConvertTable;
	g_pConvertTable = pC;
	return 1;
}

void FreeConversionList(void)
{
CONVERTER *pC, *pConv = g_pConvertTable;

	while(pConv)
		{
		pC = pConv->pNext;	/* Remember the next pointer */
		free(pConv);		/* Since it might not exist after
					  freeing the data at pConv */
		pConv = pC;
		}
	g_pConvertTable = NULL;
}


float ConvertUnit(float fValue, CONVERTER *pConv)
{
	return pConv->fMultiplier * fValue + pConv->fAddition;
}

float ConvertUnitFrom(float fValue, const char *pFromUnit)
{
CONVERTER *pC = GetConversion(pFromUnit);

	if (!pC)	return 0;
	return ConvertUnit(fValue, pC);
}

const char *GetConversionUnit(const char *pFromUnit)
{
CONVERTER *pC = GetConversion(pFromUnit);

/* We can only return a char * here because the data is global
   (stored in a linked list) and so exists.
   Also we might return a pointer to the string "unknown". This is just
   a ptr to the memory location of the text - which might stored as code-
   not data. Therefore it would not be possible to modifier it, so we
   return the char * as const.
*/
	if (!pC)	return "Unknown";
	return pC->szToUnits;
}

int DoesConversionExist(const char *pFromUnit)
{
CONVERTER *pC = GetConversion(pFromUnit);

	if (pC)	return 1;
	else	return 0;
}

