#include <stdio.h>
#include <stdlib.h>
#include "converter.h"
#include "output.h"
#include "process.h"	/* we also need process functions in here */

void Usage(void)
{
	printf("%s <value unit> | <value1 value2 unit> | <value1 value2 step unit>\n", g_pAppname);
}

void OutputConversion(float fFromValue, float fToValue, float fStep, const char *pFromUnit)
{
float fValue;
const char *pToUnit;

	if (DoesConversionExist(pFromUnit) == 0)
		{
		fprintf(stderr, "%s: Unknown unit: %s\n", g_pAppname, pFromUnit);
		return;
		}
	pToUnit = GetConversionUnit(pFromUnit);	
	for(fValue=fFromValue;fValue<=fToValue;fValue+=fStep)
		printf("%.2f%s => %.2f%s\n", fValue, pFromUnit, ConvertUnitFrom(fValue, pFromUnit), pToUnit);
}

