#include <stdio.h>
#include <stdlib.h>
#include "converter.h"
#include "config.h"
#include "output.h"
#include "process.h"
#include "debug.h"

char *g_pAppname;

/* Change the 0 below to 1 to output the contents of the linked list */
#define _DEBUG 0

int main(int argc, char *argv[])
{

	g_pAppname = argv[0];	/* store this so error messages look Unix-y */
	if (argc < 3 || argc > 5)
 		{
 		Usage();
		return EXIT_FAILURE;
		}

	if (LoadConfigFile("convert.conf") == 0) /* couldn't find local conf */
		{
		if (LoadConfigFile("/etc/convert.conf") == 0) /* try global */
			{
			fprintf(stderr, "%s: No 'convert.conf' in local dir, or /etc.\n", g_pAppname);
			return EXIT_FAILURE;
			}
		}

	if (argc == 3)
		{
		float fVal =(float)atof(argv[1]);

		OutputConversion(fVal, fVal, 1, argv[2]);
		}
	else if (argc > 3)
		{
		float fFrom, fTo;

		fFrom = (float)atof(argv[1]);
		fTo = (float)atof(argv[2]);
		if (argc == 5)
			{
			float fStepValue;

			fStepValue = (float)atof(argv[3]);
			if (fStepValue == 0)
				{
				fprintf(stderr, "%s: Step must be non-zero (defaulting to 1)\n", g_pAppname);
				fStepValue = 1;
				}
			OutputConversion(fFrom, fTo, fStepValue, argv[4]);
			}
		else
			{
			OutputConversion(fFrom, fTo, 1, argv[3]);
			}

		}
#if _DEBUG
	DbgShowConvTable();
#endif
	FreeConversionList();

return EXIT_SUCCESS;
}

