#include <stdio.h>
#include <stdlib.h>
#include "converter.h"
#include "config.h"
#include "process.h"

int LoadConfigFile(const char *pFilename)
{
CONVERTER Conv, IConv;
FILE *fp;

	/* Bring the file on disc, into memory */
	if ((fp = fopen(pFilename, "r")))/* Checks the file exists */
		{
		while(!feof(fp))
			{
			if (fscanf(fp, "%s %s %f %f", Conv.szFromUnits, Conv.szToUnits, &Conv.fMultiplier, &Conv.fAddition) != EOF)	
				{
				if (AddConversion(&Conv) == 0)
					fprintf(stderr, "%s: Could not add the %s->%s conversion.\n", g_pAppname, Conv.szFromUnits, Conv.szToUnits);
				/* Create the _inverse_ conversion */
				/* i.e. if we have f->c, produce c->f */
				strcpy(IConv.szFromUnits, Conv.szToUnits);
				strcpy(IConv.szToUnits, Conv.szFromUnits);
				/* Basic trig converts f=t*m+a to t=f/m-a/m */
				IConv.fMultiplier = 1.0f/Conv.fMultiplier;
				IConv.fAddition = -Conv.fAddition/Conv.fMultiplier;
				if (AddConversion(&IConv) == 0)
					fprintf(stderr, "%s: Could not add the %s->%s conversion.\n", g_pAppname, Conv.szToUnits, Conv.szFromUnits);
				}
			}
		fclose(fp);
		return 1;
		}
	else
		{
		return 0;
		}
}

